﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true"
    CodeBehind="ProjectApplied.aspx.cs" Inherits="GUI.Pages.ProjectApplied" %>

<%@ Register TagPrefix="uc" Namespace="GUI.Controls" Assembly="GUI" %>
<%@ Register Src="~/Controls/ProjectNavTest.ascx" TagName="ProjectNavTest" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:ProjectNavTest ID="ProjectNavTest" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
    <div class="row">
        <div class="col-md-12 col-sm-12">
        <div class="portlet light bordered light-blue">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_ProjectAplied1 %>" /> </span>
                    </div>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label"><asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Applied %>" /></label>
                                <div class="input-group">
                                    <asp:DropDownList runat="server" ValidationGroup="Validacija" CssClass="form-control" ID="ddlProjectApplied" />
                                    <span class="input-group-btn">
                                        <asp:LinkButton ID="btnAddApplied" OnClick="BtnAddClick" CssClass="btn blue" runat="server">
                                            <i class="fa fa-plus"></i>
                                        </asp:LinkButton>	
                                    </span>
                                </div> 
                                <span class="help-block"><asp:RequiredFieldValidator ID="ddlProjectAppliedRequired"  ValidationGroup="Validacija" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="ddlProjectApplied" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span>
                            </div>
                        </div>
                        <div class="col-md-9">
                                <div class="form-actions left" style="border-top: none; margin-top: 4px;">
                                    <asp:Button ID="btnSave" ValidationGroup="Validacija" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                            runat="server" />
                            </div>
                        </div>
                    </div>

                    <telerik:RadGrid ID="grdProjectApplied" runat="server" AutoPostBackOnFilter="true" OnItemCommand="grdProjectAppliedItemCommand" AllowFilteringByColumn="true" CssClass="kendo-table" Skin="Bootstrap">
                        <MasterTableView ShowHeadersWhenNoRecords="true" NoMasterRecordsText="<%$ Resources:ProjectManagementUI, Common_NoData %>"  CssClass="table table-striped table-hover"
                            ShowFooter="False" AutoGenerateColumns="False" AllowFilteringByColumn="true" AllowCustomSorting="false"  DataKeyNames="Id"  GroupingSettings-CaseSensitive="false" >
                            <Columns>
                                <telerik:GridBoundColumn UniqueName="IdColumn"  AllowFiltering="false" ShowFilterIcon="false" AutoPostBackOnFilter="true" HeaderText="Id" DataField="Id" />
                                <telerik:GridBoundColumn UniqueName="CodeColumn"  AllowFiltering="false" ShowFilterIcon="false" AutoPostBackOnFilter="true" SortExpression="Code" HeaderText="<%$ Resources:ProjectManagementUI, Common_Code %>"
                                    DataField="ProjectApplied.Code" />
                                <telerik:GridBoundColumn UniqueName="NameColumn"  AllowFiltering="true" ShowFilterIcon="false" AutoPostBackOnFilter="true" SortExpression="Name" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>"
                                    DataField="ProjectApplied.NameLocalized" />
                                <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderStyle-Width="5%"
                                    ButtonCssClass="btn btn-sm red" HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>"
                                    ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>" />
                            </Columns>
                        </MasterTableView>
                    </telerik:RadGrid>
                    </div>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
